<?php
/**
 * Module Name: myCRED Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'mycred_add' ) ) :

 //*************** Actions ***************\\
 add_action('mycred_update_user_balance','wpa_mycred_update_user_balance');
 //*************** Functions that handles the point Descriptions ***************\\
 function myCRED_Desc($ref,$creds,$entry,$log_entry){
   $mycred = mycred();
   return $mycred->parse_template_tags( $entry, $log_entry );
 }
 function wpa_mycred_update_user_balance( $user_id='', $current_balance='', $amount='', $cred_id='' ){
   if( !empty($user_id) && !empty($amount) && $amount == 0 ){
     WPAchievements_User::handle_points( $user_id, $amount );
   }
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_mycred' );
function wpachievements_add_section_mycred( $sections ) {
  $sections['mycred'] = __( 'MyCred', 'wpachievements' );
  return $sections;
}

/**
 * Overwrite the admin bar points title
 *
 * @param string $title Default title
 * @param int $user_id
 * @return string
 */
function wpachievements_mycred_admin_bar_title( $title, $user_id ) {
  $pointType = get_option('wpachievements_mycred_point_type');

  if ( function_exists('mycred_get_users_cred') ) {
    return mycred_get_users_cred( $user_id, $pointType );
  }

  return $title;
}
add_filter( 'wpachievements_admin_bar_points_menu_title', 'wpachievements_mycred_admin_bar_title', 10, 2 );

/**
 * Overwrite admin bar point history
 *
 * @param boolean $overwrite
 * @return boolean
 */
function wpachievements_mycred_admin_bar_overwrite( $overwrite ) {
  $overwrite = true;
  return $overwrite;
}
add_filter( 'wpachievements_overwrite_admin_bar_points_history', 'wpachievements_mycred_admin_bar_overwrite' );

/**
 * Show MyCred history at the admin bar
 *
 * @param int $user_id
 */
function wpachievements_mycred_admin_bar_history( $user_id ) {
  global $wpdb, $wp_admin_bar;

  // The Query
  $logQuery = new myCRED_Query_Log( array( 'user_id=' => $user_id, 'number' => 5 ) );
  $activities = $wpdb->get_results( $logQuery->request );
  $count=0;

  foreach ( $activities as $activity ) {
    $count++;
    $text = myCRED_Desc( $activity->ref, $activity->creds, $activity->entry, $activity );

    $wp_admin_bar->add_menu( array(
      'id' => 'wpachievements_points_menu_inner_'.$count,
      'parent' => 'wpachievements_points_menu',
      'title' => '<strong>'.$activity->creds.'</strong><i> '.$text.'</i><span>'.$count.'</span>',
      'meta' => array( 'class' => 'recent_point_activity' )
    ) );
  }
}
add_action( 'wpachievements_admin_bar_points_history', 'wpachievements_mycred_admin_bar_history' );

/**
 * Get MyCred user points instead of WPAchievements points
 *
 * @param int $points
 * @param int $user_id
 * @return int
 */
function wpachievements_mycred_get_user_points( $points, $user_id ) {
  $pointType = get_option('wpachievements_mycred_point_type');
  return intval( mycred_get_users_cred( $user_id, $pointType ) );
}
add_filter( 'wpachievements_get_user_points', 'wpachievements_mycred_get_user_points', 10, 2 );

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_mycred_admin', 10, 3);
function wpachievements_mycred_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'mycred' ) {
    $settings[] = array( 'title' => __( 'MyCred', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'MyCred_options' );

    $points_type_object = mycred_get_types();

    if ( empty($points_type_object) ){
      $points_type_object = array ( mycred_default => "myCRED Default");
    }

    $settings[] = array(
          'title'   => __( 'myCRED Points Type', 'wpachievements' ),
          'desc'    => __( 'Select the unique id of the point type you wish to use.', 'wpachievements' ),
          'id'      => $shortname.'_mycred_point_type',
          'type'    => 'select',
          'default' => 'mycred_default',
          'css'     => 'min-width:300px;',
          'options' => $points_type_object,
        );

    $settings[] =  array( 'type' => 'sectionend', 'id' => 'MyCred_options');

    return $settings;
  /**
  * If not, return the standard settings
  **/
  } else {
    return $defaultsettings;
  }
}

/**
 * Remove WPAchievements Points for all activities
 *
 * @param int $points
 * @return int
 */
function wpachievements_mycred_remove_wpa_points( $points ) {
  // Disable WPAchievements Point System
  $points = 0;
  return $points;
}
add_filter( 'wpachievements_new_activity_points', 'wpachievements_mycred_remove_wpa_points', 10, 1 );

/**
  * Handle points of achievements/quests and triggers after user handle points was called
  * Parameters
  *   activity:     Unique activity trigger
  *   user_id:      WordPress user ID
  *   post_id:      Post where the activity has been triggered
  *   points:       Points awarded with this activity
  *   current_user_rank:       Current User Rank
  *   reference:    MyCred Log Reference Text
  *   log_entry:    MyCred Log Description Text
  *
  * @param   array $args   Array of parameters. See default parameter
  * @return  void
  */
function wpachievements_mycred_after_handle_points( $args = array() ) {

  $defaults = array(
      'activity'          => '',
      'user_id'           => NULL,
      'post_id'           => NULL,
      'points'            => 0,
      'current_user_rank' => '',
      'reference'         => '',
      'log_entry'         => '',
    );

  $args = wp_parse_args( $args, $defaults );

  if( $args['points'] == 0 ) return;

  $pointType = get_option('wpachievements_mycred_point_type');

  if ( $args['points'] < 0 ) {
    mycred_subtract( $args['reference'], $args['user_id'], $args['points'], '%plural% '.$args['log_entry'], $args['post_id'], '', $pointType );
  }
  else {
    mycred_add( $args['reference'], $args['user_id'], $args['points'], '%plural% '.$args['log_entry'], $args['post_id'], '', $pointType );
  }
}
add_action( 'wpachievements_after_handle_points', 'wpachievements_mycred_after_handle_points' );

/**
 * Filter for getting Quest Points
 *
 * @param int $post_id
 * @return int
 */
function wpachievements_mycred_get_quest_points( $post_id ) {
  $mycred = mycred();
  return $mycred->format_creds( get_post_meta( $post_id, '_quest_points', true ) );
}

add_filter( 'wpachievements_get_quest_points', 'wpachievements_mycred_get_quest_points', 10, 1 );

/**
 * Filter for getting Achievement Points
 *
 * @param int $post_id
 * @return int
 */
function wpachievements_mycred_get_ach_points( $post_id ) {
  $mycred = mycred();
  return $mycred->format_creds( get_post_meta( $post_id, '_achievement_points', true ) );
}

add_filter( 'wpachievements_get_achievement_points', 'wpachievements_mycred_get_ach_points', 10, 1 );

/**
 * Filter for showing userpoints_html to profile fields
 *
 * @param string $userpoints_html
 * @return string
 */
function wpachievements_mycred_show_userpoints_profile_fields( $userpoints_html ) {
  return '';
}

add_filter( 'wpachievements_show_userpoints_profile_fields', 'wpachievements_mycred_show_userpoints_profile_fields', 10, 1 );

/**
 * Filter for points number format
 *
 * @param int point_diff
 * @return int
 */
function wpachievements_mycred_points_number_format( $point_diff ) {
  $mycred = mycred();
  return $mycred->format_number( $point_diff );
}

add_filter( 'wpachievements_points_number_format', 'wpachievements_mycred_points_number_format', 10, 1 );

/**
 * Filter meta_key for achievements
 *
 * @param string
 * @return string
 */
function wpachievements_mycred_meta_key( $meta_key ) {
  return 'mycred_default';
}

add_filter( 'wpachievements_meta_key', 'wpachievements_mycred_meta_key', 10, 1 );

/**
 * Filter meta_key for achievements
 *
 * @param string
 * @return string
 */
function wpachievements_mycred_is_save_points( $is_save_points ) {
  return false;
}

add_filter( 'wpachievements_is_save_points', 'wpachievements_mycred_is_save_points', 10, 1 );

endif;
?>